function useMyLocation(){
  if(!navigator.geolocation){ alert('Geolocalização não suportada'); return; }
  navigator.geolocation.getCurrentPosition((pos)=>{
    const lat = pos.coords.latitude;
    const lng = pos.coords.longitude;
    // Se existir form de busca, preencher hidden
    const latEl = document.querySelector('input[name=lat]');
    const lngEl = document.querySelector('input[name=lng]');
    if(latEl && lngEl){
      latEl.value = lat; lngEl.value = lng;
      const radius = document.querySelector('select[name=radius]');
      if(radius && !radius.value) radius.value = 5;
      latEl.closest('form').submit();
      return;
    }
    // fallback: ir para buscar com coords
    const url = new URL(window.location.origin + '/buscar');
    url.searchParams.set('lat', lat);
    url.searchParams.set('lng', lng);
    url.searchParams.set('radius', '5');
    window.location.href = url.toString();
  }, (err)=>{ alert('Não foi possível obter sua localização'); }, {enableHighAccuracy:true,timeout:8000});
}

(function initSearchMap(){
  const mapEl = document.getElementById('map');
  if(!mapEl) return;

  const center = window.__CENTER__ || {lat:-3.7319,lng:-38.5267};
  const map = L.map('map').setView([center.lat, center.lng], 12);
  L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
    maxZoom: 19, attribution: '&copy; OpenStreetMap'
  }).addTo(map);

  const markers = L.markerClusterGroup();
  const results = window.__RESULTS__ || [];
  results.forEach(r=>{
    if(!r.lat || !r.lng) return;
    const m = L.marker([r.lat, r.lng]).bindPopup(`<a href="/perfil/${encodeURIComponent(r.slug)}">${escapeHtml(r.title)}</a>`);
    markers.addLayer(m);
  });
  map.addLayer(markers);
  if(markers.getLayers().length) map.fitBounds(markers.getBounds(), {padding:[20,20]});

  // highlight card on marker click
  document.querySelectorAll('.card-hover[data-slug]').forEach(card=>{
    card.addEventListener('click', ()=> window.location.href = '/perfil/' + encodeURIComponent(card.dataset.slug));
  });
})();

(function initProfileMap(){
  const el = document.getElementById('profileMap');
  if(!el) return;
  const p = window.__PROFILE__ || {};
  const lat = p.lat || -3.7319, lng = p.lng || -38.5267;
  const map = L.map('profileMap').setView([lat,lng], 14);
  L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {maxZoom:19, attribution:'&copy; OpenStreetMap'}).addTo(map);
  if(p.lat && p.lng){
    L.marker([p.lat,p.lng]).addTo(map).bindPopup(escapeHtml(p.title || 'Local')).openPopup();
  }
})();

(function initPinMap(){
  const el = document.getElementById('pinMap');
  if(!el) return;
  const latInput = document.querySelector('input[name=lat]');
  const lngInput = document.querySelector('input[name=lng]');
  const lat = parseFloat(latInput?.value || '-3.7319');
  const lng = parseFloat(lngInput?.value || '-38.5267');

  const map = L.map('pinMap').setView([lat,lng], 14);
  L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {maxZoom:19, attribution:'&copy; OpenStreetMap'}).addTo(map);

  const marker = L.marker([lat,lng], {draggable:true}).addTo(map);

  function setInputs(a,b){
    if(latInput) latInput.value = a.toFixed(6);
    if(lngInput) lngInput.value = b.toFixed(6);
  }
  marker.on('dragend', ()=>{
    const p = marker.getLatLng();
    setInputs(p.lat,p.lng);
  });
  map.on('click', (e)=>{
    marker.setLatLng(e.latlng);
    setInputs(e.latlng.lat,e.latlng.lng);
  });
})();

function escapeHtml(str){
  return String(str||'').replace(/[&<>"']/g, s=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;' }[s]));
}
