-- database/seeds.sql
USE guia_local;

INSERT INTO settings (k, v) VALUES
('site_name','Guia Local'),
('default_city','Fortaleza'),
('default_state','CE')
ON DUPLICATE KEY UPDATE v=VALUES(v);

INSERT INTO users (name,email,password_hash,role,status,email_verified_at) VALUES
('Admin','admin@local.test','$2y$10$zQe0h1nXU1c9pQHhV9jQKOLWFKbZL1QK2nKQGfZV0H6kPzO9bQy7C','admin','active',NOW()),
('João Usuário','joao@local.test','$2y$10$YhN5q7h1q0B4y8l2v7vDkOadg1JdQbQxjO7Q3S9g3qfP0q3vB0V7i','user','active',NOW()),
('Maria Profissional','maria@local.test','$2y$10$YhN5q7h1q0B4y8l2v7vDkOadg1JdQbQxjO7Q3S9g3qfP0q3vB0V7i','professional','active',NOW()),
('Oficina Central','oficina@local.test','$2y$10$YhN5q7h1q0B4y8l2v7vDkOadg1JdQbQxjO7Q3S9g3qfP0q3vB0V7i','company','active',NOW());

INSERT INTO categories (name,slug,type) VALUES
('Mecânica','mecanica','company'),
('Eletricista','eletricista','professional'),
('Restaurante','restaurante','company'),
('Dentista','dentista','professional'),
('Beleza','beleza','both')
ON DUPLICATE KEY UPDATE name=VALUES(name), type=VALUES(type);

INSERT INTO listings (user_id,type,title,slug,bio,phone,whatsapp,status,plan,premium_until,budget_button_enabled) VALUES
((SELECT id FROM users WHERE email='maria@local.test'),'professional','Maria Eletricista Residencial','maria-eletricista-fortaleza',
'Atendimento residencial em Fortaleza. Instalações, manutenção e emergências.','85999990001','5585999990001','active','premium',DATE_ADD(NOW(), INTERVAL 30 DAY),1),
((SELECT id FROM users WHERE email='oficina@local.test'),'company','Oficina Central Aldeota','oficina-central-aldeota',
'Oficina completa: revisão, freios, suspensão e diagnóstico.','8533334444','558533334444','active','free',NULL,0);

INSERT INTO addresses (listing_id,street,number,district,city,state,zipcode,lat,lng) VALUES
((SELECT id FROM listings WHERE slug='maria-eletricista-fortaleza'),'Rua Exemplo','123','Meireles','Fortaleza','CE','60100-000',-3.7327142,-38.5009986),
((SELECT id FROM listings WHERE slug='oficina-central-aldeota'),'Av. Santos Dumont','1000','Aldeota','Fortaleza','CE','60150-161',-3.7372190,-38.4983930);

INSERT INTO listing_categories (listing_id,category_id) VALUES
((SELECT id FROM listings WHERE slug='maria-eletricista-fortaleza'), (SELECT id FROM categories WHERE slug='eletricista')),
((SELECT id FROM listings WHERE slug='oficina-central-aldeota'), (SELECT id FROM categories WHERE slug='mecanica'));

INSERT INTO services (listing_id,name,description,price_from,active) VALUES
((SELECT id FROM listings WHERE slug='maria-eletricista-fortaleza'),'Troca de disjuntor','Troca e adequação do quadro conforme norma.',150.00,1),
((SELECT id FROM listings WHERE slug='maria-eletricista-fortaleza'),'Instalação de chuveiro','Instalação segura com aterramento.',120.00,1),
((SELECT id FROM listings WHERE slug='oficina-central-aldeota'),'Revisão completa','Checklist com troca de óleo e filtros.',299.00,1);

INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 1,'08:00','18:00',0 FROM listings WHERE slug='maria-eletricista-fortaleza'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 2,'08:00','18:00',0 FROM listings WHERE slug='maria-eletricista-fortaleza'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 3,'08:00','18:00',0 FROM listings WHERE slug='maria-eletricista-fortaleza'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 4,'08:00','18:00',0 FROM listings WHERE slug='maria-eletricista-fortaleza'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 5,'08:00','18:00',0 FROM listings WHERE slug='maria-eletricista-fortaleza'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 6,'08:00','12:00',0 FROM listings WHERE slug='maria-eletricista-fortaleza'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 0,NULL,NULL,1 FROM listings WHERE slug='maria-eletricista-fortaleza'
ON DUPLICATE KEY UPDATE is_closed=VALUES(is_closed);

INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 1,'08:00','18:00',0 FROM listings WHERE slug='oficina-central-aldeota'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 2,'08:00','18:00',0 FROM listings WHERE slug='oficina-central-aldeota'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 3,'08:00','18:00',0 FROM listings WHERE slug='oficina-central-aldeota'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 4,'08:00','18:00',0 FROM listings WHERE slug='oficina-central-aldeota'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 5,'08:00','18:00',0 FROM listings WHERE slug='oficina-central-aldeota'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 6,'08:00','12:00',0 FROM listings WHERE slug='oficina-central-aldeota'
ON DUPLICATE KEY UPDATE open_time=VALUES(open_time), close_time=VALUES(close_time), is_closed=VALUES(is_closed);
INSERT INTO listing_hours (listing_id,weekday,open_time,close_time,is_closed)
SELECT id, 0,NULL,NULL,1 FROM listings WHERE slug='oficina-central-aldeota'
ON DUPLICATE KEY UPDATE is_closed=VALUES(is_closed);

INSERT INTO reviews (listing_id,user_id,rating,comment,status) VALUES
((SELECT id FROM listings WHERE slug='maria-eletricista-fortaleza'),
 (SELECT id FROM users WHERE email='joao@local.test'),
 5,'Atendimento rápido e muito profissional!','approved');
