<?php
declare(strict_types=1);

use Dotenv\Dotenv;

if (file_exists(__DIR__ . '/../.env')) {
  $dotenv = Dotenv::createImmutable(dirname(__DIR__));
  $dotenv->load();
}

mb_internal_encoding('UTF-8');

if (!extension_loaded('pdo_mysql')) { die('PDO MySQL não habilitado'); }
if (!extension_loaded('mbstring')) { die('mbstring não habilitado'); }
if (!extension_loaded('intl')) { die('intl não habilitado'); }
if (!extension_loaded('openssl')) { die('openssl não habilitado'); }
if (!extension_loaded('fileinfo')) { die('fileinfo não habilitado'); }
if (!extension_loaded('json')) { die('json não habilitado'); }
if (!extension_loaded('curl')) { die('curl não habilitado'); }
if (!extension_loaded('gd') && !extension_loaded('imagick')) { die('gd ou imagick é obrigatório'); }

ini_set('display_errors', ($_ENV['APP_DEBUG'] ?? '0') === '1' ? '1' : '0');
error_reporting(E_ALL);

session_name('guia_local_session');
session_set_cookie_params([
  'httponly' => true,
  'samesite' => 'Lax',
  'secure' => (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off'),
  'path' => '/',
]);
session_start();
