<?php
declare(strict_types=1);

use App\Core\Router;

Router::get('/', [App\Controllers\HomeController::class, 'index']);

Router::get('/buscar', [App\Controllers\SearchController::class, 'index']);
Router::get('/categoria/{slug}', [App\Controllers\CategoryController::class, 'show']);
Router::get('/perfil/{slug}', [App\Controllers\ListingController::class, 'show']);

Router::get('/entrar', [App\Controllers\AuthController::class, 'loginForm']);
Router::post('/entrar', [App\Controllers\AuthController::class, 'login']);
Router::get('/registrar', [App\Controllers\AuthController::class, 'registerForm']);
Router::post('/registrar', [App\Controllers\AuthController::class, 'register']);
Router::get('/verificar-email', [App\Controllers\AuthController::class, 'verifyEmail']);
Router::get('/esqueci-senha', [App\Controllers\AuthController::class, 'forgotForm']);
Router::post('/esqueci-senha', [App\Controllers\AuthController::class, 'forgot']);
Router::get('/resetar-senha', [App\Controllers\AuthController::class, 'resetForm']);
Router::post('/resetar-senha', [App\Controllers\AuthController::class, 'reset']);
Router::get('/sair', [App\Controllers\AuthController::class, 'logout']);

Router::post('/favoritar', [App\Controllers\FavoriteController::class, 'toggle']);
Router::post('/avaliar', [App\Controllers\ReviewController::class, 'store']);
Router::post('/responder-avaliacao', [App\Controllers\ReviewController::class, 'reply']);
Router::post('/contato', [App\Controllers\LeadController::class, 'store']);
Router::post('/denunciar', [App\Controllers\ReportController::class, 'store']);

Router::get('/painel', [App\Controllers\DashboardController::class, 'index']);
Router::get('/painel/perfil', [App\Controllers\DashboardController::class, 'editProfile']);
Router::post('/painel/perfil', [App\Controllers\DashboardController::class, 'updateProfile']);
Router::post('/painel/endereco-geocode', [App\Controllers\DashboardController::class, 'geocodeAddress']);
Router::post('/painel/servico', [App\Controllers\DashboardController::class, 'saveService']);
Router::post('/painel/servico-excluir', [App\Controllers\DashboardController::class, 'deleteService']);
Router::post('/painel/upload-logo', [App\Controllers\DashboardController::class, 'uploadLogo']);
Router::post('/painel/upload-galeria', [App\Controllers\DashboardController::class, 'uploadGallery']);
Router::post('/painel/horarios', [App\Controllers\DashboardController::class, 'saveHours']);

Router::get('/admin', [App\Controllers\AdminController::class, 'dashboard']);
Router::get('/admin/listings', [App\Controllers\AdminListingController::class, 'index']);
Router::post('/admin/listings/status', [App\Controllers\AdminListingController::class, 'setStatus']);
Router::post('/admin/listings/plan', [App\Controllers\AdminListingController::class, 'setPlan']);
Router::get('/admin/categorias', [App\Controllers\AdminCategoryController::class, 'index']);
Router::post('/admin/categorias/salvar', [App\Controllers\AdminCategoryController::class, 'save']);
Router::post('/admin/categorias/excluir', [App\Controllers\AdminCategoryController::class, 'delete']);
Router::get('/admin/avaliacoes', [App\Controllers\AdminReviewController::class, 'index']);
Router::post('/admin/avaliacoes/status', [App\Controllers\AdminReviewController::class, 'setStatus']);
Router::get('/admin/export/listings.csv', [App\Controllers\AdminExportController::class, 'listingsCsv']);
Router::get('/admin/export/reviews.csv', [App\Controllers\AdminExportController::class, 'reviewsCsv']);

Router::get('/sitemap.xml', [App\Controllers\SitemapController::class, 'index']);
