<?php
use App\Core\Helpers;
?>
<div class="row g-4 align-items-center">
  <div class="col-lg-7">
    <h1 class="display-6 fw-semibold">Encontre empresas e profissionais perto de você</h1>
    <p class="text-muted">Pesquise por serviço, profissão ou nome. Filtre por bairro, distância e “aberto agora”.</p>

    <form class="card p-3 shadow-sm" method="get" action="/buscar">
      <div class="row g-2">
        <div class="col-md-7">
          <label class="form-label">O que você procura?</label>
          <input class="form-control" name="q" placeholder="Ex.: eletricista, mecânico, dentista" />
        </div>
        <div class="col-md-5">
          <label class="form-label">Cidade</label>
          <input class="form-control" name="city" value="<?= Helpers::e($defaultCity ?? '') ?>" />
        </div>
        <div class="col-12 d-flex gap-2 mt-2">
          <button class="btn btn-primary">Buscar</button>
          <button type="button" class="btn btn-outline-secondary" onclick="useMyLocation()">Usar minha localização</button>
        </div>
      </div>
    </form>
  </div>

  <div class="col-lg-5">
    <div class="card shadow-sm">
      <div class="card-body">
        <h2 class="h6 mb-3">Categorias populares</h2>
        <div class="d-flex flex-wrap gap-2">
          <?php foreach (($popular ?? []) as $c): ?>
            <a class="badge text-bg-secondary text-decoration-none p-2" href="/categoria/<?= Helpers::e($c['slug']) ?>">
              <?= Helpers::e($c['name']) ?>
            </a>
          <?php endforeach; ?>
        </div>
      </div>
    </div>

    <div class="alert alert-info mt-3">
      <strong>MVP pronto:</strong> cadastro, busca com mapa, painel e admin.
    </div>
  </div>
</div>
