<?php
use App\Core\Helpers;
$title = 'Painel';
?>
<h1 class="h4 mb-3">Painel</h1>

<?php if (empty($listing)): ?>
  <div class="alert alert-warning">Seu perfil ainda não está disponível.</div>
<?php else: ?>
  <div class="row g-3">
    <div class="col-md-6">
      <div class="card">
        <div class="card-body">
          <h2 class="h6">Seu perfil</h2>
          <div><strong><?= Helpers::e($listing['title'] ?? '') ?></strong></div>
          <div class="small text-muted"><?= Helpers::e(($listing['city'] ?? '').' - '.($listing['district'] ?? '')) ?></div>
          <a class="btn btn-primary mt-2" href="/painel/perfil">Editar perfil</a>
          <a class="btn btn-outline-secondary mt-2" href="/perfil/<?= Helpers::e($listing['slug'] ?? '') ?>" target="_blank">Ver público</a>
        </div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card">
        <div class="card-body">
          <h2 class="h6">Estatísticas (básico)</h2>
          <div class="row">
            <?php foreach (($stats ?? []) as $k=>$v): ?>
              <div class="col-6 small"><span class="text-muted"><?= Helpers::e($k) ?></span>: <strong><?= (int)$v ?></strong></div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php endif; ?>
