<?php
use App\Core\CSRF;
use App\Core\Helpers;
$title = 'Redefinir senha';
$email = $email ?? '';
$token = $token ?? '';
?>
<div class="row justify-content-center">
  <div class="col-md-5">
    <h1 class="h4 mb-3">Redefinir senha</h1>
    <?php if (!empty($error)): ?><div class="alert alert-danger"><?= Helpers::e($error) ?></div><?php endif; ?>
    <?php if (!empty($success)): ?><div class="alert alert-success"><?= Helpers::e($success) ?></div><?php endif; ?>
    <form method="post" action="/resetar-senha" class="card p-3">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <input type="hidden" name="email" value="<?= Helpers::e($email) ?>">
      <input type="hidden" name="token" value="<?= Helpers::e($token) ?>">
      <label class="form-label">Nova senha</label>
      <input class="form-control" type="password" name="password" required minlength="8">
      <button class="btn btn-primary mt-3">Salvar</button>
    </form>
  </div>
</div>
