<?php
use App\Core\CSRF;
use App\Core\Helpers;
$title = 'Entrar';
?>
<div class="row justify-content-center">
  <div class="col-md-5">
    <h1 class="h4 mb-3">Entrar</h1>
    <?php if (!empty($error)): ?><div class="alert alert-danger"><?= Helpers::e($error) ?></div><?php endif; ?>
    <form method="post" action="/entrar" class="card p-3">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <label class="form-label">E-mail</label>
      <input class="form-control" type="email" name="email" required>
      <label class="form-label mt-2">Senha</label>
      <input class="form-control" type="password" name="password" required>
      <button class="btn btn-primary mt-3">Entrar</button>
      <div class="d-flex justify-content-between mt-2 small">
        <a href="/registrar">Criar conta</a>
        <a href="/esqueci-senha">Esqueci a senha</a>
      </div>
    </form>
  </div>
</div>
