<?php
use App\Core\Helpers;
use App\Core\CSRF;
$title = 'Admin - Avaliações';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 mb-0">Avaliações</h1>
  <div class="d-flex gap-2">
    <a class="btn btn-sm btn-outline-secondary" href="/admin">Dashboard</a>
    <a class="btn btn-sm btn-outline-secondary" href="/admin/export/reviews.csv">Export CSV</a>
  </div>
</div>

<div class="btn-group mb-3">
  <?php foreach (['pending'=>'Pendentes','approved'=>'Aprovadas','hidden'=>'Ocultas'] as $k=>$label): ?>
    <a class="btn btn-outline-primary <?= $status===$k?'active':'' ?>" href="/admin/avaliacoes?status=<?= $k ?>"><?= $label ?></a>
  <?php endforeach; ?>
</div>

<div class="table-responsive">
<table class="table table-sm align-middle">
  <thead><tr><th>ID</th><th>Listing</th><th>User</th><th>Nota</th><th>Comentário</th><th>Status</th><th>Ação</th></tr></thead>
  <tbody>
    <?php foreach (($reviews ?? []) as $r): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td class="small"><?= Helpers::e($r['listing_title'] ?? '') ?></td>
        <td class="small text-muted"><?= Helpers::e($r['user_email'] ?? '') ?></td>
        <td>⭐ <?= (int)$r['rating'] ?></td>
        <td class="small"><?= Helpers::e(mb_substr($r['comment'] ?? '', 0, 80)) ?></td>
        <td><span class="badge text-bg-<?= $r['status']==='approved'?'success':($r['status']==='hidden'?'secondary':'warning') ?>"><?= Helpers::e($r['status']) ?></span></td>
        <td>
          <form method="post" action="/admin/avaliacoes/status" class="d-inline">
            <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
            <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
            <select name="status" class="form-select form-select-sm d-inline w-auto">
              <option value="pending" <?= $r['status']==='pending'?'selected':'' ?>>pending</option>
              <option value="approved" <?= $r['status']==='approved'?'selected':'' ?>>approved</option>
              <option value="hidden" <?= $r['status']==='hidden'?'selected':'' ?>>hidden</option>
            </select>
            <button class="btn btn-sm btn-outline-primary">OK</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>
