<?php
use App\Core\Helpers;
use App\Core\CSRF;
$title = 'Admin - Listings';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 mb-0">Listings</h1>
  <div class="d-flex gap-2">
    <a class="btn btn-sm btn-outline-secondary" href="/admin">Dashboard</a>
    <a class="btn btn-sm btn-outline-secondary" href="/admin/export/listings.csv">Export CSV</a>
  </div>
</div>

<div class="btn-group mb-3">
  <?php foreach (['pending'=>'Pendentes','active'=>'Ativos','blocked'=>'Bloqueados'] as $k=>$label): ?>
    <a class="btn btn-outline-primary <?= $status===$k?'active':'' ?>" href="/admin/listings?status=<?= $k ?>"><?= $label ?></a>
  <?php endforeach; ?>
</div>

<div class="table-responsive">
<table class="table table-sm align-middle">
  <thead>
    <tr><th>ID</th><th>Título</th><th>Tipo</th><th>Status</th><th>Plano</th><th>Cidade</th><th>Ações</th></tr>
  </thead>
  <tbody>
    <?php foreach (($listings ?? []) as $l): ?>
      <tr>
        <td><?= (int)$l['id'] ?></td>
        <td><a href="/perfil/<?= Helpers::e($l['slug']) ?>" target="_blank"><?= Helpers::e($l['title']) ?></a></td>
        <td><?= Helpers::e($l['type']) ?></td>
        <td><span class="badge text-bg-<?= $l['status']==='active'?'success':($l['status']==='blocked'?'danger':'warning') ?>"><?= Helpers::e($l['status']) ?></span></td>
        <td><span class="badge text-bg-<?= $l['plan']==='premium'?'warning':'secondary' ?>"><?= Helpers::e($l['plan']) ?></span></td>
        <td class="small text-muted"><?= Helpers::e(($l['city'] ?? '').' / '.($l['district'] ?? '')) ?></td>
        <td>
          <form method="post" action="/admin/listings/status" class="d-inline">
            <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
            <input type="hidden" name="id" value="<?= (int)$l['id'] ?>">
            <select name="status" class="form-select form-select-sm d-inline w-auto">
              <option value="pending" <?= $l['status']==='pending'?'selected':'' ?>>pending</option>
              <option value="active" <?= $l['status']==='active'?'selected':'' ?>>active</option>
              <option value="blocked" <?= $l['status']==='blocked'?'selected':'' ?>>blocked</option>
            </select>
            <button class="btn btn-sm btn-outline-primary">OK</button>
          </form>

          <form method="post" action="/admin/listings/plan" class="d-inline ms-2">
            <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
            <input type="hidden" name="id" value="<?= (int)$l['id'] ?>">
            <select name="plan" class="form-select form-select-sm d-inline w-auto">
              <option value="free" <?= $l['plan']==='free'?'selected':'' ?>>free</option>
              <option value="premium" <?= $l['plan']==='premium'?'selected':'' ?>>premium</option>
            </select>
            <input type="number" class="form-control form-control-sm d-inline w-auto" name="premium_days" placeholder="dias" style="max-width:90px">
            <button class="btn btn-sm btn-outline-warning">Plano</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>
