<?php
use App\Core\Helpers;
use App\Core\CSRF;
$title = 'Admin - Categorias';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 mb-0">Categorias</h1>
  <a class="btn btn-sm btn-outline-secondary" href="/admin">Dashboard</a>
</div>

<form method="post" action="/admin/categorias/salvar" class="card p-3 mb-3">
  <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
  <div class="row g-2">
    <div class="col-md-4"><input class="form-control" name="name" placeholder="Nome" required></div>
    <div class="col-md-4"><input class="form-control" name="slug" placeholder="slug (opcional)"></div>
    <div class="col-md-3">
      <select class="form-select" name="type">
        <option value="both">both</option>
        <option value="company">company</option>
        <option value="professional">professional</option>
      </select>
    </div>
    <div class="col-md-1"><button class="btn btn-primary w-100">+</button></div>
  </div>
</form>

<div class="table-responsive">
<table class="table table-sm align-middle">
  <thead><tr><th>ID</th><th>Nome</th><th>Slug</th><th>Tipo</th><th></th></tr></thead>
  <tbody>
    <?php foreach (($categories ?? []) as $c): ?>
      <tr>
        <td><?= (int)$c['id'] ?></td>
        <td><?= Helpers::e($c['name']) ?></td>
        <td class="text-muted small"><?= Helpers::e($c['slug']) ?></td>
        <td><?= Helpers::e($c['type']) ?></td>
        <td>
          <form method="post" action="/admin/categorias/excluir" onsubmit="return confirm('Excluir?')" class="d-inline">
            <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
            <input type="hidden" name="id" value="<?= (int)$c['id'] ?>">
            <button class="btn btn-sm btn-outline-danger">Excluir</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>
