<?php
declare(strict_types=1);

namespace App\Services;

final class MailService
{
  public function send(string $to, string $subject, string $message): void
  {
    $driver = $_ENV['MAIL_DRIVER'] ?? 'log';
    $from = $_ENV['MAIL_FROM'] ?? 'no-reply@localhost';

    $headers = "From: {$from}\r\nContent-Type: text/plain; charset=UTF-8\r\n";

    if ($driver === 'mail') {
      @mail($to, $subject, $message, $headers);
      return;
    }

    // default: log
    $dir = __DIR__ . '/../../storage/logs';
    if (!is_dir($dir)) @mkdir($dir, 0775, true);
    $line = "[" . date('c') . "] TO={$to} SUBJ={$subject}\n{$message}\n---\n";
    file_put_contents($dir . '/mail.log', $line, FILE_APPEND | LOCK_EX);
  }
}
