<?php
declare(strict_types=1);

namespace App\Services;

final class Cache
{
  public static function get(string $key): ?array
  {
    $file = self::path($key);
    if (!is_file($file)) return null;
    $raw = file_get_contents($file);
    $data = json_decode($raw ?: 'null', true);
    return is_array($data) ? $data : null;
  }

  public static function set(string $key, array $value, int $ttlSeconds): void
  {
    $value['_expires'] = time() + $ttlSeconds;
    $file = self::path($key);
    $dir = dirname($file);
    if (!is_dir($dir)) @mkdir($dir, 0775, true);
    file_put_contents($file, json_encode($value), LOCK_EX);
  }

  public static function valid(?array $data): bool
  {
    return is_array($data) && isset($data['_expires']) && (int)$data['_expires'] >= time();
  }

  private static function path(string $key): string
  {
    return __DIR__ . '/../../storage/cache/' . hash('sha256', $key) . '.json';
  }
}
