<?php
declare(strict_types=1);

namespace App\Models;

final class Setting extends Model
{
  public static function get(string $k, ?string $default=null): ?string
  {
    $st=self::pdo()->prepare("SELECT v FROM settings WHERE k=? LIMIT 1");
    $st->execute([$k]);
    $row=$st->fetch();
    return $row['v'] ?? $default;
  }
}
