<?php
declare(strict_types=1);

namespace App\Models;

final class Service extends Model
{
  public static function upsert(?int $id, int $listingId, string $name, string $desc, ?float $priceFrom, int $active): int
  {
    $pdo=self::pdo();
    if ($id) {
      $st=$pdo->prepare("UPDATE services SET name=?, description=?, price_from=?, active=? WHERE id=? AND listing_id=?");
      $st->execute([$name,$desc,$priceFrom,$active,$id,$listingId]);
      return $id;
    }
    $st=$pdo->prepare("INSERT INTO services (listing_id,name,description,price_from,active) VALUES (?,?,?,?,?)");
    $st->execute([$listingId,$name,$desc,$priceFrom,$active]);
    return (int)$pdo->lastInsertId();
  }

  public static function delete(int $id, int $listingId): void
  {
    $st=self::pdo()->prepare("DELETE FROM services WHERE id=? AND listing_id=?");
    $st->execute([$id,$listingId]);
  }
}
