<?php
declare(strict_types=1);

namespace App\Models;

final class Media extends Model
{
  public static function add(int $listingId, string $path, string $type): int
  {
    $st=self::pdo()->prepare("INSERT INTO media (listing_id,path,type) VALUES (?,?,?)");
    $st->execute([$listingId,$path,$type]);
    return (int)self::pdo()->lastInsertId();
  }

  public static function logoPath(int $listingId): ?string
  {
    $st=self::pdo()->prepare("SELECT path FROM media WHERE listing_id=? AND type='logo' ORDER BY id DESC LIMIT 1");
    $st->execute([$listingId]);
    $row=$st->fetch();
    return $row['path'] ?? null;
  }
}
