<?php
declare(strict_types=1);

namespace App\Models;

final class Favorite extends Model
{
  public static function toggle(int $userId, int $listingId): bool
  {
    $pdo=self::pdo();
    $st=$pdo->prepare("SELECT 1 FROM favorites WHERE user_id=? AND listing_id=?");
    $st->execute([$userId,$listingId]);
    if ($st->fetch()) {
      $pdo->prepare("DELETE FROM favorites WHERE user_id=? AND listing_id=?")->execute([$userId,$listingId]);
      return false;
    }
    $pdo->prepare("INSERT INTO favorites (user_id,listing_id) VALUES (?,?)")->execute([$userId,$listingId]);
    return true;
  }

  public static function isFav(int $userId, int $listingId): bool
  {
    $st=self::pdo()->prepare("SELECT 1 FROM favorites WHERE user_id=? AND listing_id=?");
    $st->execute([$userId,$listingId]);
    return (bool)$st->fetch();
  }
}
