<?php
declare(strict_types=1);

namespace App\Core;

final class View
{
  public static function render(string $view, array $data = []): void
  {
    extract($data, EXTR_SKIP);
    $viewPath = __DIR__ . '/../Views/' . $view . '.php';
    if (!file_exists($viewPath)) { http_response_code(500); echo "View não encontrada"; return; }
    require __DIR__ . '/../Views/layout/header.php';
    require $viewPath;
    require __DIR__ . '/../Views/layout/footer.php';
  }
}
