<?php
declare(strict_types=1);

namespace App\Core;

use PDO;
use PDOException;

final class DB
{
  private static ?PDO $pdo = null;

  public static function pdo(): PDO
  {
    if (self::$pdo) return self::$pdo;

    $dsn = sprintf(
      'mysql:host=%s;port=%s;dbname=%s;charset=utf8mb4',
      $_ENV['DB_HOST'] ?? '127.0.0.1',
      $_ENV['DB_PORT'] ?? '3306',
      $_ENV['DB_NAME'] ?? 'guia_local'
    );

    try {
      self::$pdo = new PDO($dsn, $_ENV['DB_USER'] ?? 'root', $_ENV['DB_PASS'] ?? '', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
      ]);
      return self::$pdo;
    } catch (PDOException $e) {
      http_response_code(500);
      echo "Erro de conexão com o banco.";
      error_log($e->getMessage());
      exit;
    }
  }
}
