<?php
declare(strict_types=1);

namespace App\Core;

final class Auth
{
  public static function user(): ?array { return $_SESSION['user'] ?? null; }
  public static function check(): bool { return (bool) self::user(); }

  public static function login(array $userRow): void
  {
    session_regenerate_id(true);
    $_SESSION['user'] = [
      'id' => (int)$userRow['id'],
      'name' => $userRow['name'],
      'email' => $userRow['email'],
      'role' => $userRow['role'],
      'status' => $userRow['status'],
      'email_verified_at' => $userRow['email_verified_at'] ?? null,
    ];
  }

  public static function logout(): void
  {
    $_SESSION = [];
    if (ini_get('session.use_cookies')) {
      $params = session_get_cookie_params();
      setcookie(session_name(), '', time()-42000, $params['path'], $params['domain'], $params['secure'], $params['httponly']);
    }
    session_destroy();
  }

  public static function requireLogin(): void
  {
    if (!self::check()) Helpers::redirect('/entrar');
  }

  public static function requireRole(array $roles): void
  {
    self::requireLogin();
    $role = self::user()['role'] ?? '';
    if (!in_array($role, $roles, true)) {
      http_response_code(403);
      echo "403 - Acesso negado";
      exit;
    }
  }
}
