<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\DB;
use App\Core\Helpers;

final class SitemapController
{
  public function index(): void
  {
    header('Content-Type: application/xml; charset=UTF-8');
    $pdo = DB::pdo();
    $rows = $pdo->query("SELECT slug, updated_at, created_at FROM listings WHERE status='active' ORDER BY created_at DESC LIMIT 5000")->fetchAll() ?: [];

    $base = rtrim($_ENV['APP_URL'] ?? '', '/');
    echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    echo "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
    echo "  <url><loc>{$base}/</loc></url>\n";
    echo "  <url><loc>{$base}/buscar</loc></url>\n";

    foreach ($rows as $r) {
      $loc = $base . "/perfil/" . rawurlencode($r['slug']);
      $lastmod = substr(($r['updated_at'] ?? $r['created_at']), 0, 10);
      echo "  <url><loc>{$loc}</loc><lastmod>{$lastmod}</lastmod></url>\n";
    }
    echo "</urlset>";
  }
}
