<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Helpers;
use App\Core\RateLimiter;
use App\Models\Review;
use App\Models\Listing;

final class ReviewController extends Controller
{
  public function store(): void
  {
    Auth::requireLogin();
    $listingId = (int)($_POST['listing_id'] ?? 0);
    $rating = (int)($_POST['rating'] ?? 0);
    $comment = trim((string)($_POST['comment'] ?? ''));

    $key = 'review:' . ($_SERVER['REMOTE_ADDR'] ?? 'ip') . ':' . Auth::user()['id'];
    if (!RateLimiter::hit($key, 5, 60*10)) {
      http_response_code(429);
      echo "Muitas avaliações em pouco tempo.";
      return;
    }

    if ($listingId <= 0 || $rating < 1 || $rating > 5 || mb_strlen($comment) < 5) {
      Helpers::redirect($_SERVER['HTTP_REFERER'] ?? '/');
    }

    Review::create($listingId, (int)Auth::user()['id'], $rating, $comment);
    Helpers::redirect('/perfil/' . urlencode((string)($_POST['slug'] ?? '')));
  }

  public function reply(): void
  {
    Auth::requireRole(['professional','company','admin']);
    $reviewId = (int)($_POST['review_id'] ?? 0);
    $comment = trim((string)($_POST['comment'] ?? ''));
    if ($reviewId<=0 || mb_strlen($comment) < 2) Helpers::redirect($_SERVER['HTTP_REFERER'] ?? '/');

    // garantir que o listing pertence ao usuário (exceto admin)
    $listing = Listing::findByUser((int)Auth::user()['id']);
    if ((Auth::user()['role'] ?? '') !== 'admin') {
      if (!$listing) { http_response_code(403); echo "Sem perfil"; return; }
      $listingId = (int)$listing['id'];
    } else {
      $listingId = (int)($_POST['listing_id'] ?? 0);
    }

    Review::reply($reviewId, $listingId, $comment);
    Helpers::redirect($_SERVER['HTTP_REFERER'] ?? '/');
  }
}
