<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Models\Category;
use App\Models\Setting;

final class HomeController extends Controller
{
  public function index(): void
  {
    $popular = Category::allPopular(10);
    $siteName = Setting::get('site_name', $_ENV['APP_NAME'] ?? 'Guia Local');
    $defaultCity = Setting::get('default_city', $_ENV['DEFAULT_CITY'] ?? '');
    $this->view('home/index', compact('popular','siteName','defaultCity'));
  }
}
