<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Helpers;
use App\Models\Favorite;
use App\Models\Analytics;

final class FavoriteController extends Controller
{
  public function toggle(): void
  {
    Auth::requireLogin();
    $listingId = (int)($_POST['listing_id'] ?? 0);
    if ($listingId <= 0) { Helpers::redirect('/'); }

    $on = Favorite::toggle((int)Auth::user()['id'], $listingId);
    Analytics::log($listingId, (int)Auth::user()['id'], 'favorite', Helpers::ipBinary(), $_SERVER['HTTP_USER_AGENT'] ?? null);

    $back = $_SERVER['HTTP_REFERER'] ?? '/';
    Helpers::redirect($back);
  }
}
