<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Helpers;
use App\Models\Review;
use App\Models\AdminLog;

final class AdminReviewController extends Controller
{
  public function index(): void
  {
    Auth::requireRole(['admin']);
    $status = in_array(($_GET['status'] ?? 'pending'), ['pending','approved','hidden'], true) ? $_GET['status'] : 'pending';
    $reviews = Review::adminList($status);
    $this->view('admin/reviews', compact('reviews','status'));
  }

  public function setStatus(): void
  {
    Auth::requireRole(['admin']);
    $id=(int)($_POST['id'] ?? 0);
    $status=in_array(($_POST['status'] ?? 'pending'), ['pending','approved','hidden'], true) ? $_POST['status'] : 'pending';
    if ($id>0) {
      Review::setStatus($id,$status);
      AdminLog::add((int)Auth::user()['id'], 'set_status', 'review', $id, ['status'=>$status]);
    }
    Helpers::redirect('/admin/avaliacoes?status=' . urlencode($status));
  }
}
