<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Auth;
use App\Core\DB;

final class AdminExportController
{
  public function listingsCsv(): void
  {
    Auth::requireRole(['admin']);
    header('Content-Type: text/csv; charset=UTF-8');
    header('Content-Disposition: attachment; filename="listings.csv"');
    $out = fopen('php://output','w');
    fputcsv($out, ['id','type','title','slug','status','plan','city','district','lat','lng','created_at']);

    $pdo=DB::pdo();
    $rows=$pdo->query("SELECT l.id,l.type,l.title,l.slug,l.status,l.plan,a.city,a.district,a.lat,a.lng,l.created_at
      FROM listings l JOIN addresses a ON a.listing_id=l.id ORDER BY l.id DESC")->fetchAll() ?: [];
    foreach ($rows as $r) fputcsv($out, $r);
    fclose($out);
  }

  public function reviewsCsv(): void
  {
    Auth::requireRole(['admin']);
    header('Content-Type: text/csv; charset=UTF-8');
    header('Content-Disposition: attachment; filename="reviews.csv"');
    $out = fopen('php://output','w');
    fputcsv($out, ['id','listing_id','user_id','rating','comment','status','created_at']);

    $pdo=DB::pdo();
    $rows=$pdo->query("SELECT id,listing_id,user_id,rating,comment,status,created_at FROM reviews ORDER BY id DESC")->fetchAll() ?: [];
    foreach ($rows as $r) fputcsv($out, $r);
    fclose($out);
  }
}
