<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Helpers;
use App\Models\Category;
use App\Models\AdminLog;

final class AdminCategoryController extends Controller
{
  public function index(): void
  {
    Auth::requireRole(['admin']);
    $categories = Category::all();
    $this->view('admin/categories', compact('categories'));
  }

  public function save(): void
  {
    Auth::requireRole(['admin']);
    $id = ($_POST['id'] ?? '') !== '' ? (int)$_POST['id'] : null;
    $name = trim((string)($_POST['name'] ?? ''));
    $slug = trim((string)($_POST['slug'] ?? ''));
    $type = in_array(($_POST['type'] ?? 'both'), ['company','professional','both'], true) ? $_POST['type'] : 'both';
    if ($name==='') Helpers::redirect('/admin/categorias');

    if ($slug==='') $slug = Helpers::slug($name);
    $cid = Category::upsert($id, $name, $slug, $type);
    AdminLog::add((int)Auth::user()['id'], 'save', 'category', $cid, ['name'=>$name,'slug'=>$slug,'type'=>$type]);
    Helpers::redirect('/admin/categorias');
  }

  public function delete(): void
  {
    Auth::requireRole(['admin']);
    $id=(int)($_POST['id'] ?? 0);
    if ($id>0) {
      Category::delete($id);
      AdminLog::add((int)Auth::user()['id'], 'delete', 'category', $id, []);
    }
    Helpers::redirect('/admin/categorias');
  }
}
