# Guia Local (MVP)

Stack simples em PHP 8.2 (sem framework) + MySQL + Bootstrap + Leaflet.

## Rodar local

1) Copie o env:
```bash
cp .env.example .env
```

2) Crie o banco e rode o schema:
```bash
mysql -u root -p < database/schema.sql
```

3) Instale dependências:
```bash
composer install
```

4) Disponibilize uploads:
```bash
ln -s ../storage public/storage
```

5) Rode o servidor embutido:
```bash
php -S localhost:8000 -t public
```

Acesse: http://localhost:8000

## Contas e fluxo

- Usuário (user): pode favoritar e avaliar.
- Profissional/Empresa: tem Painel e perfil público, pode responder avaliações.
- Admin: aprova listings e avaliações; exporta CSV.

> E-mails: por padrão o `MAIL_DRIVER=log` grava em `storage/logs/mail.log`.

## Funcionalidades

- Busca com filtros + mapa (Leaflet + MarkerCluster)
- Perfis com fotos, serviços e horários (aberto agora)
- Botão Orçamento (apenas premium) + formulário de contato (leads)
- Favoritos e avaliações com moderação (anti-spam + rate limit)
- Denúncia de perfil/avaliação
- Sitemap
- Admin: aprovar/banir + premium + categorias + moderação de reviews + export CSV

## Observações

- Geocoding usa Nominatim (OSM) com cache em SQLite (db/cache.sqlite).
- Uploads: valida tipo e tamanho, gera versões (logo/gallery).
